'use strict';

/* Controllers */
function BCPEstateCtrl($scope, $rootScope, $location, $route, FrontCreatorPlaces, Company, EstatesCurrentList, EstatesList){

    Company.init();
    $scope.company =  Company;

    $scope.placesToAdd;
    $scope.placesToRemove;
    $scope.changesAdd;
    $scope.changesRemove;
    $scope.estatesToRemove;

    $scope.places = EstatesCurrentList.list;

    $scope.methodType = 'bcp-estate';

    $scope.init = function() {
        $scope.placesToAdd = [];
        $scope.placesToRemove = [];
        $scope.changesAdd = [];
        $scope.changesRemove = [];
        $scope.estatesToRemove = [];
        EstatesList.loadData();
    }

    $scope.checkEstate = function(estate) {
        if(estate.checked){
            for (var i = 0; i < $scope.placesToRemove.length; i++) {
                if ($scope.placesToRemove[i].id === estate.id) {
                    $scope.placesToRemove.splice(i, 1);
                    break;
                }
            }
        }else if(!estate.checked){
            $scope.placesToRemove.push(estate);
        }
        estate.checked = !estate.checked;
    }

    $scope.removeEstates = function() {
        angular.forEach($scope.placesToRemove, function(estate) {
            if(estate.list[0].id != 0){
                $scope.changesRemove.push('Zrezygnowano z wynajmu ' + estate.name + '.');
                $scope.estatesToRemove.push(estate);
            }
            EstatesCurrentList.removeItem(estate);
        });
        $scope.placesToRemove = [];
    }

    $scope.showEstatesOffers = function(type) {
        $rootScope.$broadcast('Estate:openEstateOffersModal', type);
    }

    $scope.isAnyChanged = function(){
        return EstatesCurrentList.isAnyChanged();
    }

    $scope.getAllCost = function() {
        var cost = 0;
        angular.forEach($scope.places, function(place) {
            if(place.isPlace()){
                cost += place.buy_now_price;
                cost += (place.surface * $scope.company.user_groups.user.market_segment.energy_cost);             
            }
        });

        return cost;
    }

    $scope.refreshList = function(){
        FrontCreatorPlaces.getRandom(function(data){
            EstatesList.setData(data);
        }, ErrorCtrl.showError);
    }

    $scope.showToken = function() {
        $scope.changesAdd = [];
        angular.forEach($scope.places, function(place) {
            if(place.list[0].id == 0){
                $scope.changesAdd.push('Wynajęto ' + place.name + '.');
            }        
        });

        var params = {};
        params.title = 'Nieruchomości';
        params.tokensConfirmsMessage = 'controlPanel,'+'estate';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = $scope.changesRemove.concat($scope.changesAdd);

        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.company, params, $scope.methodType);
        //$rootScope.$broadcast('Tokens:closeSubmitTokensModal', $scope.methodType);
    }

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType){
            $scope.places.forEach(function(item){
                if(item.list[0].id == 0){
                    item.save();                    
                }
            });
            $scope.estatesToRemove.forEach(function(item){
                item.remove();
            });
        }
        $scope.init();
        EstatesCurrentList.setOriginalLength();
    });

}

BCPEstateCtrl.$inject = ['$scope', '$rootScope', '$location', '$route', 'FrontCreatorPlaces', 'Company', 'EstatesCurrentList', 'EstatesList'];

BCPEstateCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPEstateCtrl.getRandomPlaces = function($q, $route, $rootScope, FrontCreatorPlaces, EstatesList){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorPlaces.getRandom(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}